global varlist *_hidp *_npns_dv *_tenure_dv *_dvage *_gor_dv pidp *_indpxus_xw

*merge 8 waves
cd "/Users/louiseluo/OneDrive - University Of Cambridge/Database/UKHLS_SL/stata"
use "a_indresp.dta", clear
merge m:1 a_hidp using "a_hhresp.dta", nogen
keep $varlist 
drop if pidp ==.

local wave "b c d e f g h"
foreach w of local wave {
          merge 1:1 pidp using "`w'_indresp.dta", nogen
          merge m:1 `w'_hidp using "`w'_hhresp.dta", nogen
          keep $varlist  *_indpxub_xw
		  drop if pidp ==. 
}

drop b_indpxus_xw //to inc BHPS sample, use xub instead of xus
rename a_indpxus_xw a_indpxub_xw

*reshape to long format
reshape long @_hidp @_npns_dv @_tenure_dv @_dvage @_gor_dv @_indpxub_xw, i(pidp) j(wave_s a b c d e f g h)
encode wave_s, gen(wave)
move wave wave_s
drop wave_s
foreach var of varlist _* {
           local newname = substr("`var'", 2, .)
           rename `var' `newname'
    }
drop if hidp==. //drop empty waves
	

recode tenure_dv (1/2=3 ) (3/8 = 2 ) (-9=.), gen (htn) //gen owning and renting
replace htn=1 if npns>0  & htn!=. //living with parent == living with parent, assume htn missing is random
label define htn 1 "Living with parent" 2 "Renter" 3 "Owner-Occupier" 
label value htn htn
drop npns_dv tenure_dv hidp

rename indpxub_xw weight

keep if dvage < 35 & dvage > 19 //keep young people
keep if gor_dv<10 & gor_dv>0 //keep england


svyset [pweight=wei]
svy: tab wave htn,row
